from electrum import mnemonic
import ecdsa
import time
import hmac
import hashlib

PREFIX = "100"
n = len(PREFIX)
entropy = ecdsa.util.randrange( pow(2,160) )
nonce = 0

while True:
  ss = "%040x"%(entropy+nonce)
  s = hashlib.sha256(ss.decode('hex')).digest().encode('hex')
  words = mnemonic.mn_encode(s)[0:13] # 13 random words
  seed = ' '.join(words)
  I = hmac.new("Bitcoin mnemonic", seed, hashlib.sha512).digest().encode('hex')
  if I[0:n] == PREFIX:
    break
  nonce += 1

print seed
print I


# 12 bits
# 4 bits = length of metadata.  length = 4*(x+1)    (up to 64 bits)
# 8 bits = metadata, including checksum


# octal var_int for the length: 
#   0 to e  : length up to 15  (60 bits)
#   f00 to fff : length up to 255 ( 1020 bits)  (this allows to construct difficult to mine seeds)


# examples:

# 00 to 0f          # 16 possible version numbers
# 100 to 1ff        # 256 possible version numbers
# 2000
# 30000
# 400000
# 
# f0000000000000000


# with a dict of 4096: 12 bits/word:
# 12 words = 144 bits. entropy = 132
# 13 words = 156 bits. entropy = 144
# 14 words = 168 bits. entropy = 156
# 15 words = 180 bits. entropy = 168

