/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.zbar;

import net.sourceforge.zbar.SymbolSet;

public class Symbol {
    public static final int NONE = 0;
    public static final int PARTIAL = 1;
    public static final int EAN8 = 8;
    public static final int UPCE = 9;
    public static final int ISBN10 = 10;
    public static final int UPCA = 12;
    public static final int EAN13 = 13;
    public static final int ISBN13 = 14;
    public static final int I25 = 25;
    public static final int DATABAR = 34;
    public static final int DATABAR_EXP = 35;
    public static final int CODABAR = 38;
    public static final int CODE39 = 39;
    public static final int PDF417 = 57;
    public static final int QRCODE = 64;
    public static final int CODE93 = 93;
    public static final int CODE128 = 128;
    private long peer;
    private int type;

    private static native void init();

    Symbol(long l) {
        this.peer = l;
    }

    protected void finalize() {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.peer != 0L) {
            this.destroy(this.peer);
            this.peer = 0L;
        }
    }

    private native void destroy(long var1);

    public int getType() {
        if (this.type == 0) {
            this.type = this.getType(this.peer);
        }
        return this.type;
    }

    private native int getType(long var1);

    public native int getConfigMask();

    public native int getModifierMask();

    public native String getData();

    public native byte[] getDataBytes();

    public native int getQuality();

    public native int getCount();

    public int[] getBounds() {
        int n = this.getLocationSize(this.peer);
        if (n <= 0) {
            return null;
        }
        int[] nArray = new int[4];
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            int n6;
            int n7 = this.getLocationX(this.peer, i);
            if (n2 > n7) {
                n2 = n7;
            }
            if (n3 < n7) {
                n3 = n7;
            }
            if (n4 > (n6 = this.getLocationY(this.peer, i))) {
                n4 = n6;
            }
            if (n5 >= n6) continue;
            n5 = n6;
        }
        nArray[0] = n2;
        nArray[1] = n4;
        nArray[2] = n3 - n2;
        nArray[3] = n5 - n4;
        return nArray;
    }

    private native int getLocationSize(long var1);

    private native int getLocationX(long var1, int var3);

    private native int getLocationY(long var1, int var3);

    public int[] getLocationPoint(int n) {
        int[] nArray = new int[]{this.getLocationX(this.peer, n), this.getLocationY(this.peer, n)};
        return nArray;
    }

    public native int getOrientation();

    public SymbolSet getComponents() {
        return new SymbolSet(this.getComponents(this.peer));
    }

    private native long getComponents(long var1);

    native long next();

    static {
        System.loadLibrary("zbarjni");
        Symbol.init();
    }
}

